<?php
/**
 * Copyright 2020 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
declare(strict_types=1);

namespace Magento\Mray\CodeStructuralElement\Php\Reflection\ValueAccessor;

use Magento\Mray\CodeStructuralElement\Php\Reflection\ValueAccessor;

class Unresolvable implements ValueAccessor
{
    /**
     * @return array
     */
    public function getPath(): array
    {
        return [];
    }

    /**
     * @return bool
     */
    public function resolvable(): bool
    {
        return false;
    }

    /**
     * @param ValueAccessor $other
     * @return bool
     */
    public function equal(ValueAccessor $other): bool
    {
        return false;
    }
}
