<?php
/**
 * Copyright 2020 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
declare(strict_types=1);

namespace Magento\Mray\CodeStructuralElement\Php\Reflection\ValueAccessor;

use Magento\Mray\CodeStructuralElement\Php\Reflection\TypeFactory;
use Magento\Mray\CodeStructuralElement\Php\Reflection\ValueAccessor;
use Magento\Mray\CodeStructuralElement\Php\Reflection\ValuePointer;
use phpDocumentor\Reflection\Type;
use phpDocumentor\Reflection\Types;
use function count;

class VariableName implements ValueAccessor
{
    /** @var string  */
    private $name;
    /** @var Type  */
    private $type;

    /**
     * @param string $name
     * @param Type|null $type
     */
    public function __construct(string $name, Type $type = null)
    {
        $this->name = $name;
        $this->type = $type ?? TypeFactory::get(Types\Mixed_::class);
    }

    /**
     * @inheritDoc
     */
    public function getPath(): array
    {
        $var = new ValuePointer(
            $this->name,
            $this->type
        );
        return $this->resolvable() ? [ $var ] : [];
    }

    /**
     * @return bool
     */
    public function resolvable(): bool
    {
        return $this->name !== '';
    }

    /**
     * @param ValueAccessor $other
     * @return bool
     */
    public function equal(ValueAccessor $other): bool
    {
        if (!$this->resolvable() || !$other->resolvable()) {
            return false;
        }

        $path = $other->getPath();
        if (count($path) !== 1) {
            return false;
        }

        return array_values($path)[0]->getName() === $this->name;
    }
}
