<?php
/**
 * Copyright 2020 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
declare(strict_types=1);

namespace Magento\Mray\CodeStructuralElement\Php\Reflection;

use phpDocumentor\Reflection\Type;
use RuntimeException;
use TypeError;
use function array_shift;

final class Variable
{
    /**
     * @var VariableDefinition
     */
    private $def;

    /**
     * @var Type
     */
    private $type;

    /**
     * @var VariablesContainer
     */
    private $innerContainer;

    /**
     * @param VariableDefinition $def
     */
    public function __construct(VariableDefinition $def)
    {
        if (!$def->getAccessor()->resolvable()) {
            throw new TypeError('Only variable with name may be reflected.');
        }
        $this->def = $def;
    }

    /**
     * @param VariableDefinition $def
     * @return $this
     */
    public function redefine(VariableDefinition $def): self
    {
        $redefined = new Variable(new VariableDefinition\Redefinition($this->def, $def));
        if ($this->getType() === $redefined->getType() && isset($this->innerContainer)) {
            $redefined->innerContainer = $this->innerContainer;
        }
        return $redefined;
    }

    /**
     * @return bool
     */
    public function isDefined(): bool
    {
        return $this->def->isDefinition();
    }

    /**
     * @return string
     */
    public function getName(): string
    {
        $path = $this->def->getAccessor()->getPath();
        return $path[count($path) - 1]->getName();
    }

    /**
     * @return Type
     */
    public function getType(): Type
    {
        if (!isset($this->type)) {
            $this->type = $this->def->getType();
        }
        return $this->type;
    }

    /**
     * @return VariablesContainer|null
     */
    public function getInnerContainer(): ?VariablesContainer
    {
        if (!isset($this->innerContainer)) {
            $this->innerContainer = new InnerContainer($this->def->getAccessor()->getPath());
        }
        return $this->innerContainer;
    }
}
