<?php
/**
 * Copyright 2020 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
declare(strict_types=1);

namespace Magento\Mray\CodeStructuralElement\Php\Reflection\VariableDefinition;

use Magento\Mray\CodeStructuralElement\Php\NodeRuntimeTypeResolver\Memorized;
use Magento\Mray\CodeStructuralElement\Php\NodeRuntimeTypeResolver\Resolver;
use Magento\Mray\CodeStructuralElement\Php\Reflection\ValueAccessor;
use Magento\Mray\CodeStructuralElement\Php\Reflection\VariableDefinition;
use phpDocumentor\Reflection\Type;
use PhpParser\Node\Expr;
use TypeError;
use function get_class;
use function sprintf;

class Assignment implements VariableDefinition
{
    /**
     * @var Expr|Expr\Assign|Expr\AssignRef
     */
    private $expr;
    /**
     * @var Memorized|Resolver
     */
    private $typeResolver;
    /**
     * @var ValueAccessor|ValueAccessor\Expr
     */
    private $accessor;

    /**
     * @param Expr $expr
     */
    public function __construct(Expr $expr)
    {
        if (!($expr instanceof Expr\Assign || $expr instanceof Expr\AssignRef)) {
            throw new TypeError(sprintf('Expression is not an assignment (instance of %s given).', get_class($expr)));
        }

        $this->expr = $expr;
        $this->typeResolver = new Memorized();
        $this->accessor = new ValueAccessor\Expr($expr->var);
    }

    /**
     * @return bool
     */
    public function isDefinition(): bool
    {
        return true;
    }

    /**
     * @return ValueAccessor
     */
    public function getAccessor(): ValueAccessor
    {
        return $this->accessor;
    }

    /**
     * @return Type
     */
    public function getType(): Type
    {
        return $this->typeResolver->resolve($this->expr->expr);
    }
}
