<?php
/**
 * Copyright 2020 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
declare(strict_types=1);

namespace Magento\Mray\CodeStructuralElement\Php\Reflection\VariableDefinition;

use Magento\Mray\CodeStructuralElement\Php\NodeRuntimeTypeResolver\Memorized;
use Magento\Mray\CodeStructuralElement\Php\Reflection\ValueAccessor;
use Magento\Mray\CodeStructuralElement\Php\Reflection\VariableDefinition;
use phpDocumentor\Reflection\Type;
use PhpParser\Node\Expr;

class ClosureUse implements VariableDefinition
{
    /** @var Expr|Expr\ClosureUse  */
    private $expr;
    /** @var Memorized  */
    private $typeResolver;
    /** @var ValueAccessor\Expr  */
    private $accessor;

    /**
     * @param Expr\ClosureUse $expr
     */
    public function __construct(Expr\ClosureUse $expr)
    {
        $this->expr = $expr;
        $this->typeResolver = new Memorized();
        $this->accessor = new ValueAccessor\Expr($expr->var);
    }

    /**
     * @return bool
     */
    public function isDefinition(): bool
    {
        return false;
    }

    /**
     * @return ValueAccessor
     */
    public function getAccessor(): ValueAccessor
    {
        return $this->accessor;
    }

    /**
     * @return Type
     */
    public function getType(): Type
    {
        return $this->typeResolver->resolve($this->expr->var);
    }
}
