<?php
/**
 * Copyright 2020 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
declare(strict_types=1);

namespace Magento\Mray\CodeStructuralElement\Php\Reflection\VariableDefinition;

use Magento\Mray\CodeStructuralElement\Php\Reflection\ParameterDeclaration;
use Magento\Mray\CodeStructuralElement\Php\Reflection\ValueAccessor;
use Magento\Mray\CodeStructuralElement\Php\Reflection\VariableDefinition;
use phpDocumentor\Reflection\Type;

class DeclaredParam implements VariableDefinition
{
    /** @var ParameterDeclaration  */
    private $declaration;
    /** @var ValueAccessor|ValueAccessor\Unresolvable|ValueAccessor\VariableName  */
    private $accessor;

    /**
     * @param ParameterDeclaration $declaration
     */
    public function __construct(ParameterDeclaration $declaration)
    {
        $this->declaration = $declaration;
        $this->accessor = $declaration->getName() ?
            new ValueAccessor\VariableName($declaration->getName(), $declaration->getType()) :
            new ValueAccessor\Unresolvable();
    }

    /**
     * @return bool
     */
    public function isDefinition(): bool
    {
        return false;
    }

    /**
     * @return ValueAccessor
     */
    public function getAccessor(): ValueAccessor
    {
        return $this->accessor;
    }

    /**
     * @return Type
     */
    public function getType(): Type
    {
        return $this->declaration->getType();
    }
}
