<?php
/**
 * Copyright 2020 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
declare(strict_types=1);

namespace Magento\Mray\CodeStructuralElement\Php\Reflection\VariableDefinition;

use Magento\Mray\CodeStructuralElement\Php\NodeRuntimeTypeResolver\Memorized;
use Magento\Mray\CodeStructuralElement\Php\NodeRuntimeTypeResolver\Resolver;
use Magento\Mray\CodeStructuralElement\Php\Reflection\ValueAccessor;
use Magento\Mray\CodeStructuralElement\Php\Reflection\VariableDefinition;
use phpDocumentor\Reflection\Type;
use PhpParser\Node\Expr;
use PhpParser\Node\Stmt;
use TypeError;

class GlobalVariableUse implements VariableDefinition
{
    /** @var Stmt\Global_  */
    private $globalStmt;
    /** @var Expr */
    private $var;
    /** @var Memorized|Resolver  */
    private $typeResolver;
    /** @var ValueAccessor\Expr  */
    private $accessor;

    /**
     * @param Stmt\Global_ $globalStmt
     * @param Expr $var
     */
    public function __construct(Stmt\Global_ $globalStmt, Expr $var)
    {
        if (!in_array($var, $globalStmt->vars, true)) {
            throw new TypeError('Provided var is no used in global statement.');
        }

        $this->globalStmt = $globalStmt;
        $this->var = $var;
        $this->typeResolver = new Memorized();
        $this->accessor = new ValueAccessor\Expr($var);
    }

    /**
     * @return bool
     */
    public function isDefinition(): bool
    {
        return false;
    }

    /**
     * @return ValueAccessor
     */
    public function getAccessor(): ValueAccessor
    {
        return $this->accessor;
    }

    /**
     * @return Type
     */
    public function getType(): Type
    {
        return $this->typeResolver->resolve($this->var);
    }
}
