<?php
/**
 * Copyright 2020 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
declare(strict_types=1);

namespace Magento\Mray\CodeStructuralElement\Php\Reflection\VariableDefinition;

use Magento\Mray\CodeStructuralElement\Php\Reflection\TypeFactory;
use Magento\Mray\CodeStructuralElement\Php\Reflection\ValueAccessor;
use Magento\Mray\CodeStructuralElement\Php\Reflection\VariableDefinition;
use phpDocumentor\Reflection\Type;
use phpDocumentor\Reflection\Types;
use function array_pop;

class ImplicitlyDefinedByValueAccess implements VariableDefinition
{
    /** @var ValueAccessor  */
    private $accessor;

    /**
     * @param ValueAccessor $accessor
     */
    public function __construct(ValueAccessor $accessor)
    {
        $this->accessor = $accessor;
    }

    /**
     * @return bool
     */
    public function isDefinition(): bool
    {
        return true;
    }

    /**
     * @return ValueAccessor
     */
    public function getAccessor(): ValueAccessor
    {
        return $this->accessor;
    }

    /**
     * @return Type
     */
    public function getType(): Type
    {
        $path = $this->getAccessor()->getPath();
        $top = array_pop($path);
        if (!$top) {
            return TypeFactory::get(Types\Mixed_::class);
        }
        return $top->getType();
    }
}
