<?php
/**
 * Copyright 2020 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
declare(strict_types=1);

namespace Magento\Mray\CodeStructuralElement\Php\Reflection\VariableDefinition;

use Magento\Mray\CodeStructuralElement\Php\Reflection\TypeFactory;
use Magento\Mray\CodeStructuralElement\Php\Reflection\ValueAccessor;
use Magento\Mray\CodeStructuralElement\Php\Reflection\VariableDefinition;
use phpDocumentor\Reflection\Type;
use phpDocumentor\Reflection\Types;
use PHPStan\PhpDocParser\Ast\PhpDoc\ParamTagValueNode;
use function ltrim;

class PhpDocParamTag implements VariableDefinition
{
    /** @var ParamTagValueNode  */
    private $paramTag;
    /** @var ValueAccessor|ValueAccessor\VariableName  */
    private $accessor;

    /**
     * PhpDocParamTag constructor.
     * @param ParamTagValueNode $paramTag
     */
    public function __construct(ParamTagValueNode $paramTag)
    {
        $this->paramTag = $paramTag;
        $this->accessor = new ValueAccessor\VariableName(ltrim($this->paramTag->parameterName, '$') ?: '');
    }

    /**
     * @return bool
     */
    public function isDefinition(): bool
    {
        return false;
    }

    /**
     * @return ValueAccessor
     */
    public function getAccessor(): ValueAccessor
    {
        return $this->accessor;
    }

    /**
     * @return Type
     */
    public function getType(): Type
    {
        $type = $this->getExpectedArgumentType();
        if ($this->isVariadic()) {
            $type = TypeFactory::get(Types\Array_::class, $type);
        }
        return $type;
    }

    /**
     * @return Type
     */
    private function getExpectedArgumentType(): Type
    {
        return TypeFactory::cast($this->paramTag->type);
    }

    /**
     * @return bool
     */
    private function isVariadic(): bool
    {
        return (bool)$this->paramTag->isVariadic;
    }
}
