<?php
/**
 * Copyright 2020 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
declare(strict_types=1);

namespace Magento\Mray\CodeStructuralElement\Php\Reflection\VariableDefinition;

use Magento\Mray\CodeStructuralElement\Php\Reflection\TypeFactory;
use Magento\Mray\CodeStructuralElement\Php\Reflection\ValueAccessor;
use Magento\Mray\CodeStructuralElement\Php\Reflection\VariableDefinition;
use phpDocumentor\Reflection\Type;
use PHPStan\PhpDocParser\Ast\PhpDoc\VarTagValueNode;
use function ltrim;

class PhpDocVarTag implements VariableDefinition
{
    /** @var VarTagValueNode  */
    private $varTag;
    /** @var ValueAccessor|ValueAccessor\VariableName  */
    private $accessor;

    /**
     * @param VarTagValueNode $varTag
     */
    public function __construct(VarTagValueNode $varTag)
    {
        $this->varTag = $varTag;
        $this->accessor = new ValueAccessor\VariableName(ltrim($this->varTag->variableName, '$') ?: '');
    }

    /**
     * @return bool
     */
    public function isDefinition(): bool
    {
        return false;
    }

    /**
     * @return ValueAccessor
     */
    public function getAccessor(): ValueAccessor
    {
        return $this->accessor;
    }

    /**
     * @return Type
     */
    public function getType(): Type
    {
        return TypeFactory::cast($this->varTag->type);
    }
}
