<?php
/**
 * Copyright 2020 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
declare(strict_types=1);

namespace Magento\Mray\CodeStructuralElement\Php\Reflection\VariableDefinition;

use InvalidArgumentException;
use Magento\Mray\CodeStructuralElement\Php\Reflection\TypeFactory;
use Magento\Mray\CodeStructuralElement\Php\Reflection\ValueAccessor;
use Magento\Mray\CodeStructuralElement\Php\Reflection\VariableDefinition;
use phpDocumentor\Reflection\Type;

class Redefinition implements VariableDefinition
{
    /** @var VariableDefinition  */
    private $previous;
    /** @var VariableDefinition  */
    private $current;

    /**
     * @param VariableDefinition $previous
     * @param VariableDefinition $current
     */
    public function __construct(VariableDefinition $previous, VariableDefinition $current)
    {
        if (!$current->getAccessor()->resolvable()) {
            throw new InvalidArgumentException('Only variable with known name may be redefined.');
        }
        if (!$current->getAccessor()->equal($previous->getAccessor())) {
            throw new InvalidArgumentException('Expected same name for old and new variable definition.');
        }
        $this->previous = $previous;
        $this->current = $current;
    }

    /**
     * @return bool
     */
    public function isDefinition(): bool
    {
        if ($this->current instanceof Unknown) {
            return false;
        }
        return $this->current->isDefinition() || $this->previous->isDefinition();
    }

    /**
     * @return ValueAccessor
     */
    public function getAccessor(): ValueAccessor
    {
        return $this->current->getAccessor();
    }

    /**
     * @return Type
     */
    public function getType(): Type
    {
        // todo: remove static coupling
        return TypeFactory::preciseType(
            $this->current->getType(),
            $this->previous->getType()
        );
    }
}
