<?php
/**
 * Copyright 2020 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
declare(strict_types=1);

namespace Magento\Mray\CodeStructuralElement\Php\Reflection\VariableDefinition;

use Magento\Mray\CodeStructuralElement\Php\Reflection\ValueAccessor;
use Magento\Mray\CodeStructuralElement\Php\Reflection\VariableDefinition;
use phpDocumentor\Reflection\Type;

class This_ implements VariableDefinition, ThisDefinition
{
    /** @var ThisPreDefinition  */
    private $preDefinition;

    /**
     * @param ThisPreDefinition $preDefinition
     */
    public function __construct(ThisPreDefinition $preDefinition)
    {
        $this->preDefinition = $preDefinition;
    }

    /**
     * @return bool
     */
    public function isDefinition(): bool
    {
        return true;
    }

    /**
     * @return ValueAccessor
     */
    public function getAccessor(): ValueAccessor
    {
        return $this->preDefinition->getAccessor();
    }

    /**
     * @return Type
     */
    public function getType(): Type
    {
        return $this->preDefinition->getType();
    }

    /**
     * @return Type|null
     */
    public function getParentType(): ?Type
    {
        return $this->preDefinition->getParentType();
    }
}
