<?php
/**
 * Copyright 2020 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
declare(strict_types=1);

namespace Magento\Mray\CodeStructuralElement\Php\Reflection\VariableDefinition;

use Magento\Mray\CodeStructuralElement\Php\Reflection\TypeFactory;
use phpDocumentor\Reflection\Type;
use phpDocumentor\Reflection\Types;

/**
 * Represents not defined variable.
 *
 * Undefined variable may exists only in limited scope as so it is not suitable for usage with:
 * - global context
 * - code snippets
 * - functions-like that contain include/require statements
 *
 * For not limited scope Unknown definition should be used instead as we cannot say if variable is defined or not.
 */
class Undefined extends Unknown
{
    /**
     * @return Type
     */
    public function getType(): Type
    {
        return TypeFactory::get(Types\Null_::class);
    }
}
