<?php
/**
 * Copyright 2020 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
declare(strict_types=1);

namespace Magento\Mray\CodeStructuralElement\Php\Reflection\VariableDefinition;

use Magento\Mray\CodeStructuralElement\Php\Reflection\TypeFactory;
use Magento\Mray\CodeStructuralElement\Php\Reflection\ValueAccessor;
use Magento\Mray\CodeStructuralElement\Php\Reflection\VariableDefinition;
use phpDocumentor\Reflection\Type;
use phpDocumentor\Reflection\Types;

/**
 * Represents cases when it is unknown if variable is defined or not.
 */
class Unknown implements VariableDefinition
{
    /** @var ValueAccessor|ValueAccessor\VariableName  */
    private $accessor;

    /**
     * @param string|null $name
     */
    public function __construct(?string $name = null)
    {
        $this->accessor = new ValueAccessor\VariableName($name ?? '');
    }

    /**
     * @return bool
     */
    public function isDefinition(): bool
    {
        return false;
    }

    /**
     * @return ValueAccessor
     */
    public function getAccessor(): ValueAccessor
    {
        return $this->accessor;
    }

    /**
     * @return Type
     */
    public function getType(): Type
    {
        return TypeFactory::get(Types\Mixed_::class);
    }
}
