<?php
/**
 * Copyright 2020 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
declare(strict_types=1);

namespace Magento\Mray\CodeStructuralElement\Php\Reflection\VariableDefinition;

use InvalidArgumentException;
use PhpParser\Node\Stmt;
use PhpParser\Node\Expr;
use function in_array;

/**
 * Represents special case of undefined variable when it is explicitly destroyed with unset statement.
 */
class Unset_ extends Undefined
{
    /** @var Stmt\Unset_  */
    private $stmt;

    /**
     * Unset_ constructor.
     * @param string $name
     * @param Stmt\Unset_ $stmt
     */
    public function __construct(string $name, Stmt\Unset_ $stmt)
    {
        if (!in_array($name, array_map(function (Expr $var) {
            return $var->name ?? null;
        }, $stmt->vars))) {
            throw new InvalidArgumentException('Provided unset statement does not unset specified variable.');
        }

        parent::__construct($name);
        $this->stmt = $stmt;
    }
}
