<?php
/**
 * Copyright 2020 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
declare(strict_types=1);

namespace Magento\Mray\CodeStructuralElement\Php\Reflection;

use Magento\Mray\CodeStructuralElement\Php\Reflection;

interface VariablesContainer
{
    /**
     * @param VariableDefinition $def
     */
    public function registerVariableDefinition(Reflection\VariableDefinition $def): void;

    /**
     * @param string $name
     * @return Variable
     */
    public function getVariable(string $name): Reflection\Variable;

    /**
     * @return Reflection\Variable[]
     */
    public function getVariables(): array;
}
