<?php
/**
 * Copyright 2020 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
declare(strict_types=1);

namespace Magento\Mray\CodeStructuralElement\Php\Usage;

use PhpParser\Node;

class ClassExtended implements Probe
{
    /**
     * @inheritDoc
     */
    public function check(Node $node): array
    {
        if (!$node instanceof Node\Stmt\Class_) {
            return [];
        }

        if (!$node->extends) {
            return [];
        }

        $parent = (string)$node->extends;
        return [
            new UsageCase(
                $parent,
                'extend-class',
                [
                    'position' => [
                        'startLine' => $node->extends->getStartLine(),
                        'endLine' => $node->extends->getEndLine(),
                        'startFilePos' => $node->extends->getStartFilePos(),
                        'endFilePos' => $node->extends->getEndFilePos(),
                    ],
                ]
            )
        ];
    }
}
