<?php
/**
 * Copyright 2020 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
declare(strict_types=1);

namespace Magento\Mray\CodeStructuralElement\Php\Usage;

use PhpParser\Node;

class InterfaceExtended implements Probe
{
    /**
     * @inheritDoc
     */
    public function check(Node $node): array
    {
        if (!$node instanceof Node\Stmt\Interface_) {
            return [];
        }

        $usages = [];
        foreach ($node->extends as $extends) {
            $usages[] = new UsageCase(
                (string)$extends,
                'extend-interface',
                [
                    'position' => [
                        'startLine' => $extends->getStartLine(),
                        'endLine' => $extends->getEndLine(),
                        'startFilePos' => $extends->getStartFilePos(),
                        'endFilePos' => $extends->getEndFilePos(),
                    ],
                ]
            );
        }
        return $usages;
    }
}
