<?php
/**
 * Copyright 2020 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
declare(strict_types=1);

namespace Magento\Mray\CodeStructuralElement\Php\Usage;

use PhpParser\Node;

class InterfaceImplemented implements Probe
{
    /**
     * @inheritDoc
     */
    public function check(Node $node): array
    {
        if (!$node instanceof Node\Stmt\Class_) {
            return [];
        }

        $usages = [];
        foreach ($node->implements as $implements) {
            $usages[] = new UsageCase(
                (string)$implements,
                'implement-interface',
                [
                    'position' => [
                        'startLine' => $implements->getStartLine(),
                        'endLine' => $implements->getEndLine(),
                        'startFilePos' => $implements->getStartFilePos(),
                        'endFilePos' => $implements->getEndFilePos(),
                    ],
                ]
            );
        }
        return $usages;
    }
}
