<?php
/**
 * Copyright 2020 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
declare(strict_types=1);

namespace Magento\Mray\CodeStructuralElement\Php\Usage;

use PhpParser\Node;

class MethodCall implements Probe
{
    use ClassMemberAccess;

    /**
     * @inheritDoc
     */
    public function check(Node $node): array
    {
        if (!$node instanceof Node\Expr\MethodCall &&
            !$node instanceof Node\Expr\NullsafeMethodCall &&
            !$node instanceof Node\Expr\StaticCall
        ) {
            return [];
        }

        $usages = $this->checkFromRuntimeType($node, 'call-method');
        if ($usages) {
            return $usages;
        }

        return $this->checkFromNode($node, 'call-method');
    }
}
