<?php
/**
 * Copyright 2020 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
declare(strict_types=1);

namespace Magento\Mray\CodeStructuralElement\Php\Usage;

use PhpParser\Node;

class NameDirectReference implements Probe
{
    use ClassMemberAccess;

    /**
     * @inheritDoc
     */
    public function check(Node $node): array
    {
        if (!$node instanceof Node\Name\FullyQualified) {
            return [];
        }

        return [new UsageCase(
            (string)$node,
            'reference',
            [
                'startLine' => $node->getStartLine(),
                'endLine' => $node->getEndLine(),
                'startFilePos' => $node->getStartFilePos(),
                'endFilePos' => $node->getEndFilePos(),
            ]
        )];
    }
}
