<?php
/**
 * Copyright 2020 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
declare(strict_types=1);

namespace Magento\Mray\CodeStructuralElement\Php\Usage;

use PhpParser\Node;

class PropertyAssign implements Probe
{
    use ClassMemberAccess;

    /**
     * @inheritDoc
     */
    public function check(Node $node): array
    {
        if (!$node instanceof Node\Expr\Assign &&
            !$node instanceof Node\Expr\AssignRef &&
            !$node instanceof Node\Expr\AssignOp
        ) {
            return [];
        }

        if (!$node->var instanceof Node\Expr\PropertyFetch && !$node->var instanceof Node\Expr\StaticPropertyFetch) {
            return [];
        }

        return $this->checkFromNode($node->var, 'assign-property', [
            'startLine' => $node->getStartLine(),
            'endLine' => $node->getEndLine(),
            'startFilePos' => $node->getStartFilePos(),
            'endFilePos' => $node->getEndFilePos(),
        ]);
    }
}
