<?php
/**
 * Copyright 2020 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
declare(strict_types=1);

namespace Magento\Mray\CodeStructuralElement\Php\Usage;

use PhpParser\Node;

class PropertyFetch implements Probe
{
    use ClassMemberAccess;

    /**
     * @inheritDoc
     */
    public function check(Node $node): array
    {
        if (!$node instanceof Node\Expr\PropertyFetch &&
            !$node instanceof Node\Expr\NullsafePropertyFetch &&
            !$node instanceof Node\Expr\StaticPropertyFetch
        ) {
            return [];
        }

        $parentNode = $node->getAttribute('parent');
        if ((
            $parentNode instanceof Node\Expr\Assign ||
            $parentNode instanceof Node\Expr\AssignRef ||
            $parentNode instanceof Node\Expr\AssignOp
        ) && $parentNode->var === $node) {
            return [];
        }

        $usages = $this->checkFromRuntimeType($node, 'fetch-property');
        if ($usages) {
            return $usages;
        }

        return $this->checkFromNode($node, 'fetch-property');
    }
}
