<?php
/**
 * Copyright 2020 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
declare(strict_types=1);

namespace Magento\Mray\CodeStructuralElement\Php\Usage;

use function array_merge;

class UsageCase
{
    /**
     * @var string
     */
    private $what;

    /**
     * @var string
     */
    private $how;

    /**
     * @var array
     */
    private $location;

    /**
     * @var array
     */
    private $details;

    /**
     * @param string $what
     * @param string $how
     * @param array $location
     * @param array $details
     */
    public function __construct(
        string $what,
        string $how,
        array $location = [],
        array $details = []
    ) {
        $this->what = $what;
        $this->how = $how;
        $this->location = $location;
        $this->details = $details;
    }

    /**
     * @param array $context
     */
    public function setDeclarationContext(array $context): void
    {
        $this->details = array_merge($context, $this->details);
    }

    /**
     * @param array $context
     */
    public function setLocationContext(array $context): void
    {
        $this->location = array_merge($context, $this->location);
    }

    /**
     * @return string
     */
    public function getWhat(): string
    {
        return $this->what;
    }

    /**
     * @return string
     */
    public function getHow(): string
    {
        return $this->how;
    }

    /**
     * @return array
     */
    public function getDetails(): array
    {
        return $this->details;
    }

    /**
     * @return array
     */
    public function getLocation(): array
    {
        return $this->location;
    }

    /**
     * @return array
     */
    public function describe(): array
    {
        return array_merge(
            $this->details,
            [
                'location' => $this->location,
            ]
        );
    }
}
