<?php
/**
 * Copyright 2020 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
declare(strict_types=1);

namespace Magento\Mray\CodeStructuralElement\Php\Usage;

class UsageRegistry
{
    /** @var array */
    private $usages = [];

    /**
     * @param UsageCase $usage
     */
    public function register(UsageCase $usage)
    {
        $this->usages[$usage->getWhat()][$usage->getHow()][] = $usage;
    }

    /**
     * @return array
     */
    public function getUsages(): array
    {
        return $this->usages;
    }
}
