<?php
/**
 * Copyright 2020 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
declare(strict_types=1);

namespace Magento\Mray\CodeStructuralElement;

interface StructuralElement
{
    /**
     * @return FullQualifiedStructuralElementName|null
     */
    public function getFqsen(): ?FullQualifiedStructuralElementName;

    /**
     * @return string
     */
    public function getType(): string;

    /**
     * @return string|null
     */
    public function getChecksum(): ?string;

    /**
     * @param string $attr
     * @param array $val
     */
    public function setAttribute(string $attr, array $val): void;

    /**
     * @param string $attr
     * @param mixed $default
     * @return mixed
     */
    public function getAttribute(string $attr, $default = null);

    /**
     * @return array
     */
    public function getAttributes(): array;
}
