<?php
/**
 * Copyright 2020 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
declare(strict_types=1);

namespace Magento\Mray\CodeStructuralElement;

interface StructuralElementRegistry
{
    /**
     * @param StructuralElement $se
     */
    public function register(StructuralElement $se): void;
    /**
     * @param StructuralElementRelation $ser
     */
    public function registerRelation(StructuralElementRelation $ser): void;
    /**
     * @param FullQualifiedStructuralElementName $fqsen
     * @return StructuralElement|null
     */
    public function find(FullQualifiedStructuralElementName $fqsen): ?StructuralElement;
    /**
     * @param FullQualifiedStructuralElementName $fqsen
     * @return StructuralElementRelation[]
     */
    public function findRelations(FullQualifiedStructuralElementName $fqsen): array;
    /**
     * @param FullQualifiedStructuralElementName $fqsen
     * @return StructuralElementRelation[]
     */
    public function findRelationsInitiatedBy(FullQualifiedStructuralElementName $fqsen): array;
    /**
     * @param FullQualifiedStructuralElementName $fqsen
     * @return StructuralElementRelation[]
     */
    public function findRelationsInvolve(FullQualifiedStructuralElementName $fqsen): array;
}
