<?php
/**
 * Copyright 2020 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
declare(strict_types=1);

namespace Magento\Mray\CodeStructuralElement;

class StructuralElementRelationType
{
    /** @var array  */
    private static $instances = [];

    /**
     * @return StructuralElementRelationType
     */
    final public static function type(): StructuralElementRelationType
    {
        if (!isset(self::$instances[static::class])) {
            self::$instances[static::class] = new static();
        }
        return new self::$instances[static::class];
    }

    /** @var string  */
    private $code;

    /**
     * StructuralElementRelationType constructor.
     */
    protected function __construct()
    {
        $this->setCode('AwareOf');
    }

    /**
     * @param string $relationType
     * @return bool
     */
    public function isCaseOf(string $relationType)
    {
        return $this instanceof $relationType;
    }

    /**
     * @param string $code
     */
    final protected function setCode(string $code): void
    {
        $this->code = $code;
    }

    /**
     * @return string
     */
    final public function getCode(): string
    {
        return $this->code;
    }
}
