<?php
/**
 * Copyright 2022 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
declare(strict_types=1);

namespace Magento\Mray\Console\Command;

use Exception;
use Magento\Mray\Composer\MagentoDownloader;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputArgument;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;

class DownloadForApiIndex extends Command
{
    /**
     * @var string
     */
    protected static $defaultName = 'download:magento';

    /**
     * @inheritDoc
     */
    protected function configure()
    {
        $this->addArgument(
            'release',
            InputArgument::REQUIRED,
            'Which Magento version to download.',
        );
        $this->addArgument(
            'out',
            InputArgument::REQUIRED,
            'The directory where to fetch packages.'
        );
    }

    /**
     * @param InputInterface $input
     * @param OutputInterface $output
     * @return int
     */
    protected function execute(InputInterface $input, OutputInterface $output)
    {
        try {
            $dir = $input->getArgument('out');
            $version = $input->getArgument('release');

            (new MagentoDownloader())->execute($dir, $version);
        } catch (Exception $e) {
            $output->getErrorOutput()->writeln($e->getMessage());
            return 1;
        }

        return 0;
    }
}
