<?php
/**
 * Copyright 2020 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
declare(strict_types=1);

namespace Magento\Mray\Index\Collection;

use Magento\Mray\Index\Data\DataTransferObject;

interface DataCollection
{
    /**
     * @return DataTransferObject[]
     */
    public function exportData(): array;

    /**
     * @param array $data
     */
    public function importData(array $data): void;
}
