<?php
/**
 * Copyright 2022 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
declare(strict_types=1);

namespace Magento\Mray\Index\Collection;

class DbSchema implements DataCollection
{
    /**
     * @var array
     */
    private $data = [];

    /**
     * @param array $dbSchema
     */
    public function register(array $dbSchema): void
    {
        $this->data = array_replace_recursive($this->data, $dbSchema);
    }

    /**
     * @inheritDoc
     */
    public function exportData(): array
    {
        return $this->data;
    }

    /**
     * @inheritDoc
     */
    public function importData(array $data): void
    {
        $this->data = $data;
    }
}
