<?php
/**
 * Copyright 2020 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
declare(strict_types=1);

namespace Magento\Mray\Index\Data;

use Magento\Mray\Index\Collection\Dictionary;

class MagentoApiDeclaration extends DataTransferObject
{
    /** @var string|null  */
    private $since;
    /** @var MagentoDeprecationDeclaration|null  */
    private $deprecated;

    /**
     * @param array $packed
     * @param Dictionary $dict
     * @return array|null[]
     */
    protected static function unpackData(array $packed, Dictionary $dict): array
    {
        $data = [
            'since' => $packed[0] ?? null,
        ];
        if (isset($packed[1])) {
            $data['deprecated'] = $dict->read($packed[1]);
        }
        return $data;
    }

    /**
     * @param Dictionary $dict
     * @return array
     */
    protected function packData(Dictionary $dict): array
    {
        if (isset($this->deprecated)) {
            $dRef = $dict->write($this->deprecated->pack($dict));
        }
        return [
            0 => $this->since,
            1 => $dRef ?? null,
        ];
    }

    /**
     * @param mixed $data
     */
    public function __construct($data)
    {
        $this->since = $data['since'] ?? null;
        $this->deprecated = isset($data['deprecated']) ? new MagentoDeprecationDeclaration($data['deprecated']) : null;
    }
}
