<?php
/**
 * Copyright 2020 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
declare(strict_types=1);

namespace Magento\Mray\Index\Data;

use Magento\Mray\Index\Collection\Dictionary;

class MagentoDeprecationDeclaration extends DataTransferObject
{
    /** @var string|null  */
    private $since;

    /** @var string|null  */
    private $comment;

    /** @var string|null  */
    private $see;

    /**
     * @param array $packed
     * @param Dictionary $dict
     * @return array|null[]
     */
    protected static function unpackData(array $packed, Dictionary $dict): array
    {
        return [
            'since' => $packed[0] ?? null,
            'comment' => $packed[1] ?? null,
            'see' => $packed[2] ?? null
        ];
    }

    /**
     * @param Dictionary $dict
     * @return array
     */
    protected function packData(Dictionary $dict): array
    {
        return [
            0 => $this->since,
            1 => $this->comment,
            2 => $this->see
        ];
    }

    /**
     * @param mixed $data
     */
    public function __construct($data)
    {
        $this->since = $data['since'] ?? null;
        $this->comment = $data['comment'] ?? null;
        $this->see = $data['see'] ?? null;
    }
}
