<?php
/**
 * Copyright 2020 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
declare(strict_types=1);

namespace Magento\Mray\Index\Data;

use Magento\Mray\Index\Collection\Dictionary;
use function explode;
use function is_string;
use function ltrim;

class PhpFqsenMeta extends DataTransferObject
{
    /** @var string  */
    protected $classLikeName;
    /** @var string|null  */
    protected $memberName;

    /**
     * @param array $packed
     * @param Dictionary $dict
     * @return array
     */
    protected static function unpackData(array $packed, Dictionary $dict): array
    {
        return [
            'classLikeName' => isset($data[0]) ? $dict->read($data[0]) : null,
            'memberName' => isset($data[1]) ? $data[1] : null,
        ];
    }

    /**
     * @param Dictionary $dict
     * @return array
     */
    protected function packData(Dictionary $dict): array
    {
        return [
            0 => isset($this->classLikeName) ? $dict->write($this->classLikeName) : null,
            1 => $this->memberName,
        ];
    }

    /**
     * @param mixed $data
     */
    public function __construct($data)
    {
        if (is_string($data)) {
            $data = explode('::', $data, 2);
            $this->classLikeName = ltrim($data[0], '\\');
            $this->memberName = $data[1] ?? null;
        } else {
            $this->classLikeName = $data['classLikeName'] ?? null;
            $this->memberName = $data['memberName'] ?? null;
        }
    }

    /**
     * @return string
     */
    public function __toString(): string
    {
        $fqsen = $this->classLikeName;
        if ($this->memberName) {
            $fqsen .= '::' . $this->memberName;
        }
        return $fqsen;
    }
}
