<?php
/**
 * Copyright 2020 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
declare(strict_types=1);

namespace Magento\Mray\Index;

use Magento\Mray\MagentoApiIndex\Api;
use function array_push;
use function class_exists;

class GetMagentoNamespaces
{
    /**
     * @var array
     */
    private $namespaces = [];

    /**
     * @param string $version
     * @return string[]
     */
    public function execute(string $version): array
    {
        if (!isset($this->namespaces[$version])) {
            $this->namespaces[$version] = $this->getMagentoNamespacesFromIndex($version);
        }
        return $this->namespaces[$version];
    }

    /**
     * @param string $version
     * @return array
     */
    private function getMagentoNamespacesFromIndex(string $version): array
    {
        $componentsIndex = (new Api())->getComponentsIndex($version);

        $namespaces = [];
        foreach ($componentsIndex->modules() as $module) {
            array_push($namespaces, ...($module['namespaces'] ?? []));
        }
        foreach ($componentsIndex->libraries() as $library) {
            array_push($namespaces, ...($library['namespaces'] ?? []));
        }
        foreach ($componentsIndex->themes() as $theme) {
            array_push($namespaces, ...($theme['namespaces'] ?? []));
        }
        return $namespaces;
    }
}
