<?php
/**
 * Copyright 2020 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
declare(strict_types=1);

namespace Magento\Mray\Index;

class IsCoreDependency
{
    /**
     * @var GetMagentoNamespaces
     */
    private $getMagentoNamespaces;

    /**
     * @param GetMagentoNamespaces $getMagentoNamespaces
     */
    public function __construct(GetMagentoNamespaces $getMagentoNamespaces)
    {
        $this->getMagentoNamespaces = $getMagentoNamespaces;
    }

    /**
     * @param string $reference
     * @param string $version
     * @return bool
     */
    public function execute(string $reference, string $version)
    {
        $namespace = explode('\\', ltrim($reference, '\\'));
        array_pop($namespace);

        // ignore native PHP elements
        if (empty($namespace)) {
            return false;
        }

        foreach ($this->getMagentoNamespaces->execute($version) as $magentoNamespace) {
            if (strcasecmp(substr($reference, 0, strlen($magentoNamespace)), $magentoNamespace) === 0) {
                return true;
            }
        }
        return false;
    }
}
