<?php
/**
 * Copyright 2020 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
declare(strict_types=1);

namespace Magento\Mray\Index\Persistence;

use Magento\Mray\Api\Data\MagentoReleaseIndexResult;

class AppendIndex
{
    /**
     * @param MagentoReleaseIndexResult $indexResult
     * @param string $indexDir
     */
    public function execute(MagentoReleaseIndexResult $indexResult, string $indexDir): void
    {
        (new MagentoReleaseStorage($indexDir))->append(
            $indexResult->getVersion()
        );

        (new ComponentsStorage($indexDir))->append(
            $indexResult->getComponents(),
            $indexResult->getVersion()
        );

        (new MagentoApiStorage($indexDir))->append(
            $indexResult->getApi(),
            $indexResult->getVersion()
        );

        (new VirtualTypesStorage($indexDir))->append(
            $indexResult->getVirtualTypes(),
            $indexResult->getVersion()
        );

        (new PhpCodeStorage($indexDir))->append(
            $indexResult->getPhpCode(),
            $indexResult->getVersion()
        );

        (new DictionaryStorage($indexDir))->append(
            $indexResult->getDictionary()
        );

        (new DbSchemaStorage($indexDir))->saveVersion(
            $indexResult->getDbSchema(),
            $indexResult->getVersion()
        );
    }
}
