<?php
/**
 * Copyright 2020 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
declare(strict_types=1);

namespace Magento\Mray\Index\Persistence;

use Magento\Mray\Index\Collection\MagentoComponents;
use function clearstatcache;
use function is_dir;
use function mkdir;
use function realpath;
use function sprintf;

class ComponentsStorage
{
    /** @var string  */
    private $dir;

    /**
     * @param string $dataDir
     */
    public function __construct(string $dataDir)
    {
        $dir = $dataDir . '/components';
        if (!is_dir($dir)) {
            mkdir($dir, 0755, true);
            clearstatcache(true, $dir);
        }

        $this->dir = realpath($dir);
    }

    /**
     * @param MagentoComponents $components
     * @param string $version
     */
    public function append(MagentoComponents $components, string $version)
    {
        $writer = new FileWriter();
        $writer->write(
            sprintf('%s/%s.php', $this->dir, $version),
            $components->exportData()
        );
    }
}
