<?php
/**
 * Copyright 2020 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
declare(strict_types=1);

namespace Magento\Mray\Index\Persistence;

use Magento\Mray\Index\Collection\Dictionary;
use Magento\Mray\MagentoApiIndex\Model\Volumes;
use function array_merge;
use function clearstatcache;
use function is_dir;
use function mkdir;
use function realpath;
use function sprintf;
use function str_replace;
use function strtolower;
use function substr;

class DictionaryStorage
{
    /**
     * @var string
     */
    private $dir;

    /**
     * @var Volumes
     */
    private $volumes;

    /**
     * @param string $dataDir
     */
    public function __construct(string $dataDir)
    {
        $dir = $dataDir . '/dictionary';
        if (!is_dir($dir)) {
            mkdir($dir, 0755, true);
            clearstatcache(true, $dir);
        }

        $this->dir = realpath($dir);
        $this->volumes = new Volumes();
    }

    /**
     * @param Dictionary $dictionary
     */
    public function append(Dictionary $dictionary)
    {
        $reader = new FileReader();
        $writer = new FileWriter();

        foreach ($this->volumes->groupByVolumes($dictionary->exportData()) as $volume => $data) {
            $file = sprintf('%s/%s.php', $this->dir, $volume);
            // phpcs:ignore Magento2.Performance.ForeachArrayMerge
            $writer->write($file, array_merge(
                $reader->read($file),
                $data
            ));
        }
    }
}
