<?php
/**
 * Copyright 2020 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
declare(strict_types=1);

namespace Magento\Mray\Index\Scanner;

use Magento\Mray\Package\AbstractTree\ScannerSubject;

/**
 * Probe detects if check is a package or not.
 */
interface Probe
{
    /**
     * @param ScannerSubject $subject
     * @return Sample|null
     * @throws FailedAssumption when probe expect detect a component but internal data of marker file are not valid.
     */
    public function check(ScannerSubject $subject): ?Sample;
}
