<?php
/**
 * Copyright 2020 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
declare(strict_types=1);

namespace Magento\Mray\Index\Scanner\Probe;

use Magento\Mray\Index\Scanner\Probe;
use Magento\Mray\Index\Scanner\Sample;
use Magento\Mray\Package\AbstractTree\ScannerSubject;
use function basename;
use function in_array;

class MagentoUtilityDir implements Probe
{
    /**
     * @inheritDoc
     */
    public function check(ScannerSubject $subject): ?Sample
    {
        $dir = basename($subject->location());
        return new Sample(
            null,
            $this->isMagentoUtilityDir($dir) ? Sample::NESTED_PACKAGES_NONE : Sample::NESTED_PACKAGES_MAYBE
        );
    }

    /**
     * @param string $path
     * @return bool
     */
    private function isMagentoUtilityDir(string $path): bool
    {
        return in_array($path, [
            'var',
            'generated',
            'dev',
            'pub'
        ]);
    }
}
