<?php
/**
 * Copyright 2020 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
declare(strict_types=1);

namespace Magento\Mray\Index\Scanner\Probe\SubjectReader;

use DOMDocument;
use Magento\Mray\Package\AbstractTree\ScannerSubjectReader;
use RuntimeException;
use SimpleXMLElement;
use function libxml_clear_errors;
use function libxml_use_internal_errors;
use function sprintf;

class SimpleXml implements ScannerSubjectReader
{
    /**
     * @param string $path
     * @return mixed|SimpleXMLElement
     */
    public function read(string $path)
    {
        $dom = new DOMDocument();
        $dom->recover = true;

        libxml_use_internal_errors(true);
        // phpcs:ignore Generic.PHP.NoSilencedErrors
        if (!@$dom->load($path)) {
            throw new RuntimeException(sprintf('Unable load XML from "%s".', $path));
        }
        libxml_clear_errors();

        $xml = simplexml_import_dom($dom);
        if ($xml instanceof SimpleXMLElement) {
            return $xml;
        }

        throw new RuntimeException(sprintf('Unable read XML from "%s".', $path));
    }
}
