<?php
/**
 * Copyright 2020 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
declare(strict_types=1);

namespace Magento\Mray\Index\Scanner;

use Magento\Mray\Package\AbstractTree\Node\Package;

/**
 * Sample represents Probe result and describes if a package found and if the scan may be stopped.
 */
class Sample
{
    /**
     * No information regarding nested packages.
     *
     * Most of probes should return this recommendation.
     */
    public const NESTED_PACKAGES_MAYBE = 0;
    /**
     * Expected presence of nested packages.
     */
    public const NESTED_PACKAGES_EXPECTED = 1;
    /**
     * Nested packages are not expected.
     */
    public const NESTED_PACKAGES_NONE = 2;

    /** @var Package|null  */
    private $package;
    /** @var int  */
    private $nestedPackagesCanExist;

    /**
     * @param Package|null $package
     * @param int $nestedPackagesCanExist
     */
    public function __construct(?Package $package, int $nestedPackagesCanExist = self::NESTED_PACKAGES_MAYBE)
    {
        $this->package = $package;
        $this->nestedPackagesCanExist = $nestedPackagesCanExist;
    }

    /**
     * @return Package|null
     */
    public function package(): ?Package
    {
        return $this->package;
    }

    /**
     * Provides Probe recommendation for scanning nested content.
     *
     * @return int One of NESTED_PACKAGES_* constants which may be used as bitmask
     */
    public function nestedPackagesCanExist(): int
    {
        return $this->nestedPackagesCanExist;
    }
}
