<?php
/**
 * Copyright 2020 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
declare(strict_types=1);

namespace Magento\Mray\Index\Scanner;

use Magento\Mray\Package\AbstractTree\Node\Package;
use Magento\Mray\Package\AbstractTree\ScannerSubject;

/**
 * Tuner may precise result of a probe by adding new information to Package node or cancel probe decision
 * and removing Probe node
 */
interface Tuner
{
    /**
     * @param ScannerSubject $subject
     * @param Package[] $packages
     * @return Package[]
     */
    public function tune(ScannerSubject $subject, array $packages): array;
}
