<?php
/**
 * Copyright 2020 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
declare(strict_types=1);

namespace Magento\Mray\Index\Scanner\Tuner;

use Magento\Mray\Index\Scanner\Tuner;
use Magento\Mray\Package\AbstractTree\ScannerSubject;
use function array_map;

class Chain implements Tuner
{
    /**
     * @var Tuner[]
     */
    private $tuners;

    /**
     * @param Tuner[] $tuners
     */
    public function __construct(array $tuners)
    {
        $this->tuners = array_map(function (Tuner $t) {
            return $t;
        }, $tuners);
    }

    /**
     * @inheritDoc
     */
    public function tune(ScannerSubject $subject, array $packages): array
    {
        foreach ($this->tuners as $tuner) {
            $packages = $tuner->tune($subject, $packages);
        }
        return $packages;
    }
}
