<?php
/**
 * Copyright 2022 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
declare(strict_types=1);

namespace Magento\Mray\Index\Scanner\Tuner;

use Magento\Mray\Package\AbstractTree\Component\MagentoModule;
use Magento\Mray\Index\Scanner\Tuner;
use Magento\Mray\Package\AbstractTree\ScannerSubject;
use Magento\Mray\Model\Xml\GetXmlFileContent;

class DbSchemaNodeSetter implements Tuner
{
    /**
     * @var GetXmlFileContent
     */
    private $getDbSchema;

    /**
     *
     */
    public function __construct()
    {
        $this->getDbSchema = new GetXmlFileContent();
    }

    /**
     * @inheritDoc
     */
    public function tune(ScannerSubject $subject, array $packages): array
    {
        foreach ($packages as $package) {
            if (!$package instanceof MagentoModule || !isset($package->attributes['path'])) {
                continue;
            }
            foreach ($this->getDbSchema->execute($package->attributes['path'], 'db_schema.xml') as $path => $xml) {
                $package->attributes['dbSchema'][$path] = $xml;
            }
        }
        return $packages;
    }
}
