<?php
/**
 * Copyright 2022 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
declare(strict_types=1);

namespace Magento\Mray\Index\Scanner\Tuner\Filter;

use Magento\Mray\Package\AbstractTree\Component\MagentoEcosystemAsset;
use Magento\Mray\Package\AbstractTree\Node\Package;

class MagentoAssets implements FilterInterface
{
    /**
     * @param Package[] $packages
     * @return Package[]
     */
    public function filter(array $packages): array
    {
        return array_filter($packages, function (Package $package) {
            return $package instanceof MagentoEcosystemAsset;
        });
    }
}
