<?php
/**
 * Copyright 2020 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
declare(strict_types=1);

namespace Magento\Mray\Index\Scanner\Tuner;

use Magento\Mray\Package\AbstractTree\Component\Project;
use Magento\Mray\Package\AbstractTree\Component\MagentoEcosystemAsset;
use Magento\Mray\Package\AbstractTree\Node\Component;
use Magento\Mray\Package\AbstractTree\DistributionPackage\Composer;
use Magento\Mray\Package\AbstractTree\Identifier\Versioned;
use Magento\Mray\Index\Scanner\Tuner;
use Magento\Mray\Package\AbstractTree\ScannerSubject;

class MagentoComposerDistribution implements Tuner
{
    public const ATTR_DISTRIBUTION_PACKAGE = 'distributionPackage';
    public const ATTR_NAMESPACES = 'namespaces';

    /**
     * @inheritDoc
     */
    public function tune(ScannerSubject $subject, array $packages): array
    {
        $composerPkg = null;
        $magentoComponents = [];
        foreach ($packages as $pkg) {
            if ($pkg instanceof Composer) {
                $composerPkg = $pkg;
            } elseif ($pkg instanceof Component &&
                      !$pkg instanceof Project &&
                      $pkg instanceof MagentoEcosystemAsset
            ) {
                $magentoComponents[] = $pkg;
            }
        }
        if (isset($composerPkg) && !empty($magentoComponents)) {
            if ($composerPkg->identifier instanceof Versioned) {
                foreach ($magentoComponents as $magentoComponent) {
                    $magentoComponent->identifier = new Versioned(
                        $magentoComponent->identifier,
                        $composerPkg->identifier->version
                    );
                    $magentoComponent->setAttribute(
                        self::ATTR_DISTRIBUTION_PACKAGE,
                        $composerPkg->identifier->identifier
                    );
                    $magentoComponent->setAttribute(
                        self::ATTR_NAMESPACES,
                        $composerPkg->namespaces ?? []
                    );
                }
            } else {
                foreach ($magentoComponents as $magentoComponent) {
                    $magentoComponent->setAttribute(
                        self::ATTR_DISTRIBUTION_PACKAGE,
                        $composerPkg->identifier
                    );
                    $magentoComponent->setAttribute(
                        self::ATTR_NAMESPACES,
                        $composerPkg->namespaces ?? []
                    );
                }
            }
        }
        return $packages;
    }
}
