<?php
/**
 * Copyright 2020 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
declare(strict_types=1);

namespace Magento\Mray\Index\Scanner\Tuner;

use Magento\Mray\MagentoApiIndex\Api;
use Magento\Mray\MagentoApiIndex\Index\Components;
use Magento\Mray\Package\AbstractTree\Component\MagentoProject;
use Magento\Mray\Package\AbstractTree\Component\MagentoModule;
use Magento\Mray\Package\AbstractTree\Component\MagentoLibrary;
use Magento\Mray\Package\AbstractTree\Component\MagentoTheme;
use Magento\Mray\Package\AbstractTree\Component\MagentoEcosystemAsset;
use Magento\Mray\Package\AbstractTree\Node\Component;
use Magento\Mray\Package\AbstractTree\Identifier\Versioned;
use Magento\Mray\Index\Scanner\Tuner;
use Magento\Mray\Package\AbstractTree\ScannerSubject;
use function class_exists;

class MagentoCustomCodeFilter implements Tuner
{
    /**
     * @var Components
     */
    private $componentsIndex;

    /**
     * @var string
     */
    private $version;

    /**
     * @param string $version
     */
    public function __construct(string $version)
    {
        $this->version = $version;
    }

    /**
     * @inheritDoc
     */
    public function tune(ScannerSubject $subject, array $packages): array
    {
        $componentsIndex = $this->getComponentsIndex();

        foreach ($packages as $package) {
            if ($package instanceof MagentoProject) {
                return $packages;
            }
            if (!$package instanceof Component || !$package instanceof MagentoEcosystemAsset) {
                continue;
            }

            $packageId = $package->identifier;
            if ($packageId instanceof Versioned) { // todo: check with version
                $packageId = $packageId->identifier;
            }
            $packageId = (string)$packageId;

            // todo: provide unified interface
            if ($package instanceof MagentoModule && $componentsIndex->module($packageId)) {
                return [];
            }
            if ($package instanceof MagentoLibrary && $componentsIndex->library($packageId)) {
                return [];
            }
            if ($package instanceof MagentoTheme && $componentsIndex->theme($packageId)) {
                return [];
            }
        }
        return $packages;
    }

    /**
     * @return Components
     */
    private function getComponentsIndex(): Components
    {
        if (!$this->componentsIndex) {
            $this->componentsIndex = (new Api())->getComponentsIndex($this->version);
        }
        return $this->componentsIndex;
    }
}
