<?php
/**
 * Copyright 2022 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
declare(strict_types=1);

namespace Magento\Mray\Index\Scanner\Tuner;

use Magento\Mray\Package\AbstractTree\Component\MagentoProject;
use Magento\Mray\Index\Scanner\Tuner;
use Magento\Mray\Package\AbstractTree\ScannerSubject;
use Magento\Mray\Parse\Xml\GetDiXmlDeclarations;
use Magento\Mray\Model\Xml\GetXmlFileContent;

class ProjectRootDiXmlNodeSetter implements Tuner
{
    /**
     * @var GetDiXmlDeclarations
     */
    private $diXmlDeclarationsParser;

    /**
     * @var GetXmlFileContent
     */
    private $diXmlFileContentLoader;

    /**
     *
     */
    public function __construct()
    {
        $this->diXmlDeclarationsParser = new GetDiXmlDeclarations();
        $this->diXmlFileContentLoader = new GetXmlFileContent();
    }

    /**
     * @inheritDoc
     */
    public function tune(ScannerSubject $subject, array $packages): array
    {
        foreach ($packages as $package) {
            if ($package instanceof MagentoProject && $package->attributes['path']) {
                $diXmlFileContent = $this->diXmlFileContentLoader->execute(
                    $package->attributes['path'] . '/app',
                    'di.xml'
                );
                if (count($diXmlFileContent) !== 1) {
                    return $packages;
                }
                $usageCases = $this->diXmlDeclarationsParser->execute(current($diXmlFileContent));
                foreach ($usageCases as $case) {
                    $case->setLocationContext(['file' => $package->attributes['path']]);
                }
                $package->attributes['diXmlDeclarations'][$package->attributes['path']] = $usageCases;
            }
        }
        return $packages;
    }
}
